//  Listing 11.7. Klasa String z przecionym operatorem przypisania

#include <iostream>
using namespace std;

class String 				// dynamicznie lokowana tablica znakowa
{
char *str; 				// wskanik do acucha znakw
int len;				
char* allocate(const char* s)          	// prywatna metoda
{ char *p = new char[len+1];           	// przydzia pamici dla obiektu
if (p==NULL) exit(1);               	// jeli si nie powiodo - zatrzymaj
strcpy(p,s);                       	// kopiuj tekst na stert
return p; }                        	// zwrot wskanika do pamici na stercie
  public:
String (int length=0);  		// konstruktor konwertujcy / domylny
String(const char*);         		// konstruktor konwertujcy
String(const String& s);     		// konstruktor kopiujcy
~String ();              		// destruktor - zwolnienie dynamicznej pamici
void operator += (const String&); 	// konkatenacja
String operator = (const String&); 	// operator przypisania
void modify(const char*); 		// zmiana zawartoci tablicy
bool operator == (const String&) const; 	// porwnanie zawartoci
const char* show() const; 		// zwrot wskanika do tablicy
} ;

String::String(int length)
{ len = length;
str = allocate(""); } 			// kopiuj pusty ancuch na stert

String::String(const char* s)
{ len = strlen(s); 			// pomiar dugoci tekstu wejciowego
str = allocate(s); 			// przydziel pami, skopiuj tekst
cout << " Utworzony: '" << str <<"'\n"; }

String::String(const String& s)         // konstruktor kopiujcy
{ len = s.len;                    	// pomiar dugoci tekstu wejciowego
str = allocate(s.str);            	// przydziel pami, skopiuj tekst
cout << " Skopiowany: '" << str <<"'\n"; }

String::~String()
{ delete str; }             			// zwrot pamici na stercie
void String::operator += (const String& s) 	// referencyjny parametr
{ len = strlen(str) + strlen(s.str); 		// cakowita dugo
char* p = new char[len + 1];   			// przydzia wystarczajcej iloci miejsca
if (p==NULL) exit(1);          			// sprawd, czy si powiodo
strcpy(p,str);                 			// kopiuj pierwsz cz rezultatu
strcat(p,s.str);                      		// dodaj drug cz rezultatu
delete str;                            		// wana czynno
str = p; }                             		// teraz p moe znikn

String String::operator = (const String& s)
{ if (&s == this) return *this; 		// czy to "samoobsuga"?
delete str; 					// tego nie robi konstruktor kopiujcy
len = s.len; 					// kopiuj dane, ale bez wskanika
str = allocate(s.str); 				// przydziel pami, skopiuj tekst
cout << " Przypisany: '" << str <<"'\n"; 	// tylko w celu ledzenia dziaania programu
return *this; } // zwr obiekt docelowy do kodu klienta

bool String::operator==(const String& s) const 		// porwnanie zawartoci
{ return strcmp(str,s.str)==0; } 			// zwraca 0, jeli takie same

const char* String::show() const 		// ochrona danych przed zmian
{ return str; }

void String::modify(const char a[]) 		// bez zarzdzania pamici
{ strncpy(str,a,len-1); 			// ochrona przed przepenieniem
str[len-1] = 0; } 			// poprawne zakoczenie acucha znakw

String enterData()
{ cout << " Podaj miasto do odszukania: "; 	// pytamy uytkownika
char data[200]; 				// niezgrabne rozwizanie
cin >> data; 				// wczytujemy miasto podane przez uytkownika
return String(data); } 			// konstruktor konwertujcy

int main()
{ 
cout << endl << endl;
enum { MAX = 4} ;
String data[4]; 			// tablica zoona z obiektw (baza danych)
char *c[4] = { "Atlanta", "Boston", "Chicago", "Denver" };
for (int j=0; j<MAX; j++)
{ data[j] = c[j]; }             	// przypisanie: data[j].operator=(c[j]);
String u; int i;
	// nastpujce wyraenie wymaga przypisania,
	// a nie wywoania konstruktora kopii
u = enterData();             
for (i=0; i<MAX; i++)
{ if (data[i] == u) break; } 		// instrukcje warunkowe (data[i].operator==(u))
if (i == MAX)
cout << " Miasto " << u.show() << " nie zostao znalezione\n";  	// nie ma
else
cout << " Miasto " << u.show() << " zostao znalezione\n";     		// jest
return 0;
}
